BEGIN { curnode = 0;

		picl["trace_start"]		= 1;
		picl["open"] 			= 2;
		picl["load"] 			= 3;
		picl["send"] 			= 4;
		picl["recv"] 			= 6;
		picl["recv_blocking"] 	= 7;
		picl["recv_waking"] 	= 8;
		picl["message"] 		= 9;
		picl["sync"] 			= 10;
		picl["compstate"] 		= 11;
		picl["commstate"] 		= 12;
		picl["close"] 			= 13;
		picl["trace_level"] 	= 14;
		picl["trace_mark"] 		= 15;
		picl["trace_message"] 	= 16;
		picl["trace_stop"] 		= 17;
		picl["trace_flush"] 	= 18;
		picl["trace_exit"] 		= 19;
		picl["trace_begin"] 	= 20;
		picl["trace_end"] 		= 21;
		picl["host"]			= -32768;

		xab["enroll"] 	= 18;
		xab["leave"]		= 21;
		xab["rcv"] 		= 24;
		xab["snd"] 		= 28;
		xab["whoami"] 	= 32;
		xab["rcv_done"]	= 33;
		
		}

# get rid of the extra lines
/^[^0-9]/  { next; }

# if it's enroll, assign a node number 
$3 == xab["enroll"] || $3 == xab["whoami"] { 
	# if the node isn't known already 
	if (node[$5 $6] == "") {
		node[$5 $6] = curnode++ 
		if(bsec == "") {
			# store the base time
			while (length($2) < 6) $2 = "0" $2;
			bsec = $1 "." $2;
			}
		# start tracing on this node
		print picl["trace_start"], 0, 0, node[$5 $6], 0, 0, 0;
		}
	}

# if it's send, generate the PICL event, use serial number for length 
$3 == xab["snd"] { 
	while (length($2) < 6) $2 = "0" $2;
	ttime = $1"."$2;
#	print "ttime before sub", ttime;
	ttime = ttime - bsec;
#	print "ttime after sub", ttime;
	nsf = split(ttime, tsec, ".");
#	print "nsf", nsf;
	dest = node[$10 $12];
	if (dest == "") dest = "-32768";
	while (length(tsec[2]) < 6) tsec[2] = tsec[2] "0";
	print picl["send"], tsec[1], tsec[2], node[$5 $6], dest, $14, $16;
	}

# if it's rcv, generate the PICL event
$3 == xab["rcv"] { 
	while (length($2) < 6) $2 = "0" $2;
	ttime = $1 "." $2;
	ttime = ttime - bsec;
	split(ttime, tsec, ".");
	while (length(tsec[2]) < 6) tsec[2] = tsec[2] "0";
	print picl["recv_blocking"], tsec[1], tsec[2], node[$5 $6], $8
	}

# if it's rcv_done
$3 == xab["rcv_done"] {
	while (length($2) < 6) $2 = "0" $2;
	ttime = $1 "." $2;
	ttime = ttime - bsec;
	split(ttime, tsec, ".");
	while (length(tsec[2]) < 6) tsec[2] = tsec[2] "0";
	print picl["recv_waking"], tsec[1], tsec[2], node[$5 $6], node[$10 $12], $14, $16
	}
	
# if it's leave
$3 == xab["leave"] {
        while (length($2) < 6) $2 = "0" $2;
        ttime = $1 "." $2;
        ttime = ttime - bsec;
        split(ttime, tsec, ".");
        while (length(tsec[2]) < 6) tsec[2] = tsec[2] "0";
        print picl["close"], tsec[1], tsec[2], node[$5 $6]
        }


# END	{ for (comp in node)
# 		print comp, node[comp]
#	}
